# version.sh
# ==========
# This file contains information needed to build the firmware package
# for subsequent upload to the update server
# The environment variables defined here are used in the process of
# building the update package and for the subsequent firmware download
# and update.
# This file will be sourced, so the syntax is the same as a bash script.

# Overall firmware version - build nuwill be overwritten by TeamCity
FIRMWARE_VERSION="1.52.99.9681"
FIRMWARE_VERSION_MAJOR_MINOR="1.52"

# Current version stage: 0=DEV, 1..98=RC, 99=PROD
FIRMWARE_VERSION_STAGE="99"

# Flag: this version will be released as TA package (1) or regular package (0)
FIRMWARE_IS_TYPE_APPROVED="0"

# For which certification entities is this firmware type-approved
# (NONE, or PTB, METAS, LNE, ...  separated by |)
FIRMWARE_TYPE_APPROVALS="None"

# U-Boot version - using U-Boot notation
UBOOT_VERSION="1.11.99.322-g100c68e688"

# Kernel version - <major>.<minor>.<refresh>-<RT patch version>
KERNEL_VERSION="4.9.11-rt9_NTi-Audio-XL3_P01A-F-gdd5f580b83"

# Teamcity reference build (Rootfs Second Stage project)
REFERENCE_BUILD=9681

# Userspace version - <major>.<minor>.<refresh>
ROOTFS_VERSION="1.52.99.9681"

# TA container version - <major>.<minor>.<refresh>
TA_VERSION="1.52.99.9681"

# NON-TA container version - <major>.<minor>.<refresh>
NONTA_VERSION="1.52-gf2797d96dd"

# OsUi container version - <major>.<minor>.<refresh>
OSUI_VERSION="1.52.99.9681"

# COMM container version - <major>.<minor>.<refresh>
COMM_VERSION="1.52.99.9681"

# Overlays version - <major>.<minor>.<refresh>
OVLY_VERSION="1.52"

# Update scripts version - <major>.<minor>.<refresh>
UPDATE_VERSION="1.52-g6e699b164e"

# Battery Update scripts version - <major>.<minor>.<refresh>
MSP_VERSION="V2.38(AB)-V3.153(CDF)"

# U-Boot files
uboot_files_list=( 'SPL.mmc' 'u-boot.img.mmc' )
uboot_signed_files_list=( 'SPL.HAB.mmc.signed' 'u-boot-ivt.img.mmc.signed' )

# Kernel files
kernel_files_list=( 'zImage' )
kernel_signed_files_list=( 'zImage-ivt_signed' )
dtb_files_list=(    'imx7d-var-som-emmc-maxiboard.dtb' 	\
                    'imx7d-var-som-emmc-xl3-p01a.dtb'	\
                    'imx7d-var-som-emmc-xl3-p01b.dtb' 	\
                    'imx7d-var-som-emmc-xl3-p01c.dtb' 	\
                    'imx7d-var-som-emmc-xl3-p01d.dtb' 	\
                    'imx7d-var-som-emmc-xl3-p01f.dtb' 	\
                    'imx7d-var-som-emmc-xl3-p01b-stripped.dtb' )

# Squashfs files
squash_ta_files_list=( 'rootfs.squashfs' 'ta.squashfs' )
squash_nonta_files_list=( 'comm.squashfs' 'nonta.squashfs' 'osui.squashfs' 'usr.squashfs')

# Overlay directories
overlay_directories=(   'overlays/containers/comm/delta0/etc'           \
                        'overlays/containers/comm/delta0/root'          \
                        'overlays/containers/comm/etc_overlay/etc'      \
                        'overlays/containers/comm/etc_overlay/olwork'   \
                        'overlays/containers/comm/olwork'               \
                        'overlays/containers/comm/root_overlay/olwork'  \
                        'overlays/containers/comm/root_overlay/root'    \
                        'overlays/containers/comm/home_overlay/olwork'  \
                        'overlays/containers/comm/home_overlay/home'    \
                        'overlays/containers/ta/delta0/etc'             \
                        'overlays/containers/ta/delta0/root'            \
                        'overlays/containers/ta/etc_overlay/etc'        \
                        'overlays/containers/ta/etc_overlay/olwork'     \
                        'overlays/containers/ta/olwork'                 \
                        'overlays/containers/nonta/delta0/etc'          \
                        'overlays/containers/nonta/delta0/root'         \
                        'overlays/containers/nonta/etc_overlay/etc'     \
                        'overlays/containers/nonta/etc_overlay/olwork'  \
                        'overlays/containers/nonta/olwork'              \
                        'overlays/containers/osui/delta0/etc'           \
                        'overlays/containers/osui/delta0/root'          \
                        'overlays/containers/osui/etc_overlay/etc'      \
                        'overlays/containers/osui/etc_overlay/olwork'   \
                        'overlays/containers/osui/olwork'               )

# Update script and accessories
update_script_list=(    'update.sh'         \
                        'update.py'         )

update_emcy_script_list=(   'emcy-update.sh'    \
                            'emcy-update.py'    )

# Update service and accessories
update_service_list=(   'xl3-update.sh'     \
                        'xl3-update.bmp'    \
                        'update_success.bmp'\
                        'update_failed.bmp' )

# Update at startup service and accessories
update_boot_script_list=(   'boot-update.sh'    \
                            'boot-update.py'    )

update_boot_service_list=(   'xl3-boot-update.sh'     \
                             'xl3-boot-update.bmp'    )

# Battery management script and accessories
battery_update_list=(   'xl3scripts/bsl.py'             \
                        'xl3scripts/open_bsl.sh'        \
                        'xl3scripts/msp430-i2cbsl-tool' \
                        'xl3scripts/prog430.sh'         \
                        'xl3scripts/erase430.sh'        \
                        'xl3scripts/xl3pwd.txt'         \
                        'xl3scripts/xl3pwr.txt' )

battery_fw_list=(       'P01A/xl3pwr.txt' \
                        'P01B/xl3pwr.txt' )

battery_fw_c_list=(     'P01C/xl3pwr.txt'  \
                        'PP01C/xl3pwr.txt' )

# Background images
screen_files_list=(     'nti1.bmp'      \
                        'nti2.bmp'      \
                        'welcome1.bmp'  \
                        'welcome2.bmp'  \
                        'restart.bmp'   \
                        'shutdown.bmp'  )

